/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.AdventurerMapsHandler;
import net.mehvahdjukaar.supplementaries.common.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilitiesHandler;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.entities.VillagerTradesHandler;
import net.mehvahdjukaar.supplementaries.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.fluids.ModSoftFluids;
import net.mehvahdjukaar.supplementaries.mixins.accessors.ChickenEntityAccessor;
import net.mehvahdjukaar.supplementaries.mixins.accessors.HorseEntityAccessor;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.commands.ModCommands;
import net.mehvahdjukaar.supplementaries.setup.DispenserStuff;
import net.mehvahdjukaar.supplementaries.setup.LootTableStuff;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.Spawns;
import net.mehvahdjukaar.supplementaries.world.data.map.CMDreg;
import net.mehvahdjukaar.supplementaries.world.structures.StructureLocator;
import net.mehvahdjukaar.supplementaries.world.structures.StructureRegistry;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="supplementaries", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModSetup {
    private static boolean hasFinishedSetup = false;
    private static boolean firstTagLoad = false;

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                StructureRegistry.setup();
                StructureLocator.init();
                CompatHandler.init();
                CMDreg.init(event);
                Spawns.registerSpawningStuff();
                CapabilitiesHandler.register();
                ComposterBlock.field_220299_b.put((Object)((IItemProvider)ModRegistry.FLAX_SEEDS_ITEM.get()), 0.3f);
                ComposterBlock.field_220299_b.put((Object)((IItemProvider)ModRegistry.FLAX_ITEM.get()), 0.65f);
                ComposterBlock.field_220299_b.put((Object)((IItemProvider)ModRegistry.FLAX_BLOCK_ITEM.get()), 1.0f);
                ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(((Item)ModRegistry.FLAX_ITEM.get()).getRegistryName(), ModRegistry.FLAX_POT);
                FlowerPotHandler.init();
                CapturedMobsHelper.refresh();
                ModSoftFluids.init();
                NetworkHandler.registerMessages();
                ItemsOverrideHandler.registerOverrides();
                LootTableStuff.init();
                ModSetup.registerMobFoods();
                hasFinishedSetup = true;
            }
            catch (Exception e) {
                Supplementaries.LOGGER.throwing((Throwable)new Exception("Exception during mod setup:" + e + ". This is a big bug"));
                ModSetup.terminateWhenSetupFails();
            }
        });
    }

    private static void terminateWhenSetupFails() {
        Supplementaries.LOGGER.throwing((Throwable)new Exception("Mod setup has failed to complete. This might be due to some mod incompatibility. Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors. Executing 69/0"));
        int a = 69 / 0;
    }

    private static void registerMobFoods() {
        ArrayList<ItemStack> chickenFood = new ArrayList<ItemStack>();
        Collections.addAll(chickenFood, ChickenEntityAccessor.getFoodItems().func_193365_a());
        chickenFood.add(new ItemStack((IItemProvider)ModRegistry.FLAX_SEEDS_ITEM.get()));
        ChickenEntityAccessor.setFoodItems(Ingredient.func_234819_a_(chickenFood.stream()));
        ArrayList<ItemStack> horseFood = new ArrayList<ItemStack>();
        Collections.addAll(horseFood, HorseEntityAccessor.getFoodItems().func_193365_a());
        horseFood.add(new ItemStack((IItemProvider)ModRegistry.FLAX_ITEM.get()));
        horseFood.add(new ItemStack((IItemProvider)ModRegistry.FLAX_BLOCK_ITEM.get()));
        HorseEntityAccessor.setFoodItems(Ingredient.func_234819_a_(horseFood.stream()));
    }

    @SubscribeEvent
    public static void onTagLoad(TagsUpdatedEvent event) {
        if (!hasFinishedSetup) {
            ModSetup.terminateWhenSetupFails();
        }
        if (!firstTagLoad) {
            firstTagLoad = true;
            DispenserStuff.registerBehaviors();
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void villagerTradesEvent(VillagerTradesEvent ev) {
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue() && ev.getType().equals(VillagerProfession.field_221156_f)) {
            ((List)ev.getTrades().get(3)).add(new BasicTrade(new ItemStack((IItemProvider)ModRegistry.FLAX_SEEDS_ITEM.get(), 15), new ItemStack((IItemProvider)Items.field_151166_bC), 16, 2, 0.05f));
        }
        AdventurerMapsHandler.loadCustomTrades();
        AdventurerMapsHandler.addTrades(ev);
    }

    @SubscribeEvent
    public static void registerWanderingTraderTrades(WandererTradesEvent event) {
        VillagerTradesHandler.registerWanderingTraderTrades(event);
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent e) {
        LootTableStuff.injectLootTables(e);
    }
}

